/** @file   MMapAccessInterface.h
 * @brief   Declaration of MMapAccessInterface
 * @version $Revision: 1.2 $
 * @date    $Date: 2006/07/13 16:26:33 $
 * @author  Tomi Lamminsaari
 */

#ifndef H_WWW_MMAPACCESSINTERFACE_H
#define H_WWW_MMAPACCESSINTERFACE_H

namespace eng2d {
  class Vec2D;
};


namespace WeWantWar {

/** @class  MMapAccessIntercace
 * @brief   Interface for LightBeam to access the map.
 * @author  Tomi Lamminsaari
 */
class MMapAccessInterface
{
public: // Constructors, destructor, operators
  virtual ~MMapAccessInterface() { }

  /** Tells if the block on certain position has collision flag 0 on.
   * @return  true if collision flag is on.
   */
  virtual bool mapCollision( const eng2d::Vec2D& aPosition, int aLayer=0 ) const = 0;
  
  /** Tells if the block on certain position has collision flag 1 on.
   * @reutrn  true if collision flag is on.
   */
  virtual bool bulletCollision( const eng2d::Vec2D& aPosition ) const = 0;
};

};  // end of namespace
#endif
